<?php
/**
 * Widgets class.
 *
 * @category   Class
 * @package    RubikElementorWidgets
 * @subpackage WordPress
 * @author     Mostafa Kalantari Fard <design3nter@gmail.com>
 * @copyright  2022 Webrubik
 * @license    https://opensource.org/licenses/GPL-3.0 GPL-3.0-only
 * @link       link(https://www.rtl-theme.com/,
 *             Rubik Elementor Widgets)
 * @since      1.0.0
 * php version 7.3.9
 */

namespace RubikElementorWidgets;

use RubikElementorWidgets\Modules\Posts\Skins\Skin_Wr_Posts;
use RubikElementorWidgets\Modules\Posts\Skins\Skin_Wr_Resume;
use RubikElementorWidgets\Modules\Posts\Skins\Skin_Wr_Services;
use RubikElementorWidgets\Modules\Posts\Skins\Skin_Wr_Team;

defined( 'ABSPATH' ) || die();

/**
 * Class Plugin
 *
 * Main Plugin class
 *
 * @since 1.0.0
 */
class Widgets {

    /**
     * Instance
     *
     * @since 1.0.0
     * @access private
     * @static
     *
     * @var Plugin The single instance of the class.
     */
    private static $instance = null;

    /**
     * Instance
     *
     * Ensures only one instance of the class is loaded or can be loaded.
     *
     * @since 1.0.0
     * @access public
     *
     * @return Plugin An instance of the class.
     */
    public static function instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     *  widgets styles
     *
     * Load widgets styles
     *
     */
    public function widget_styles() {
        wp_enqueue_style( 'wr-custom', plugins_url( 'assets/css/wr-custom.css', __FILE__ ) );
    }

    /**
     * Include Widgets files
     *
     * Load widgets files
     *
     * @since 1.0.0
     * @access private
     */
    private function include_skins_files() {
        require_once(plugin_dir_path( RUBIK_ELEMENTOR_WIDGETS ) . 'modules/posts/skins/skin-wr-services.php');
        require_once(plugin_dir_path( RUBIK_ELEMENTOR_WIDGETS ) . 'modules/posts/skins/skin-wr-posts.php');
        require_once(plugin_dir_path( RUBIK_ELEMENTOR_WIDGETS ) . 'modules/posts/skins/skin-wr-resume.php');
        require_once(plugin_dir_path( RUBIK_ELEMENTOR_WIDGETS ) . 'modules/posts/skins/skin-wr-team.php');
    }

    public function elementor_init() {
        // Its is now safe to include Widgets skins
        $this->include_skins_files();
        // Register skin
        add_action( 'elementor/widget/posts/skins_init', function( $widget ) {
            $widget->add_skin( new Skin_Wr_Services($widget) );
            $widget->add_skin( new Skin_Wr_Posts($widget) );
            $widget->add_skin( new Skin_Wr_Team($widget) );
            $widget->add_skin( new Skin_Wr_Resume($widget) );
        } );
    }

    /**
     *  Plugin class constructor
     *
     * Register plugin action hooks and filters
     *
     * @since 1.0.0
     * @access public
     */
    public function __construct() {
        // Register widget scripts

        add_action( 'elementor/frontend/after_enqueue_styles', [ $this, 'widget_styles' ] );

        add_action( 'elementor/init', [ $this, 'elementor_init' ], 0 );
    }
}

// Instantiate the Widgets class.
Widgets::instance();
