<?php
namespace RubikElementorWidgets\Modules\Posts\Skins;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;
use ElementorPro\Modules\Posts\Skins\Skin_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Skin_Wr_Resume extends Skin_Base {

    protected function _register_controls_actions() {
        parent::_register_controls_actions();
    }

    public function get_id() {
        return 'wr_resume';
    }

    public function get_title() {
        return __( 'باکس نمونه کارها', 'elementor-pro' );
    }

    public function start_controls_tab( $id, $args ) {
        $args['condition']['_skin'] = $this->get_id();
        $this->parent->start_controls_tab( $this->get_control_id( $id ), $args );
    }

    public function end_controls_tab() {
        $this->parent->end_controls_tab();
    }

    public function start_controls_tabs( $id ) {
        $args['condition']['_skin'] = $this->get_id();
        $this->parent->start_controls_tabs( $this->get_control_id( $id ) );
    }

    public function end_controls_tabs() {
        $this->parent->end_controls_tabs();
    }

    public function register_controls( Widget_Base $widget ) {
        $this->parent = $widget;

        $this->register_columns_controls();
        $this->register_post_count_control();
        $this->register_title_controls();
        $this->register_excerpt_controls();
        $this->register_link_controls();
    }

    public function register_design_controls() {
        $this->register_design_layout_controls();
    }

    protected function register_excerpt_controls() {
        $this->add_control(
            'show_excerpt',
            [
                'label' => __( 'Excerpt', 'elementor-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'elementor-pro' ),
                'label_off' => __( 'Hide', 'elementor-pro' ),
                'default' => 'yes',
            ]
        );
    }

    protected function render_post_header() {
        $optional_attributes_html = $this->get_optional_link_attributes_html();

        $settings = $this->parent->get_settings();
        $setting_key = $this->get_control_id( 'thumbnail_size' );
        $settings[ $setting_key ] = [
            'id' => get_post_thumbnail_id(),
        ];
        @$thumbnail_html = Group_Control_Image_Size::get_attachment_image_src( get_post_thumbnail_id(), $setting_key, $settings );
        ?>
        <article <?php post_class( [ 'elementor-post elementor-grid-item wr-resume' ] ); ?> style="background-image: url('<?php echo $thumbnail_html; ?>'); margin-top: 10px">
        <a href="<?php echo $this->current_permalink; ?>" <?php echo $optional_attributes_html; ?>>
        <?php
    }

    protected function render_post_footer() {
        ?>
        </a>
        </article>
        <?php
    }

    protected function render_thumbnail() {
        if ( 'none' === $this->get_instance_value( 'thumbnail' ) ) {
            return;
        }

        $settings = $this->parent->get_settings();
        $setting_key = $this->get_control_id( 'thumbnail_size' );
        $settings[ $setting_key ] = [
            'id' => get_post_thumbnail_id(),
        ];
        $thumbnail_html = Group_Control_Image_Size::get_attachment_image_html( $settings, $setting_key );

        if ( empty( $thumbnail_html ) ) {
            return;
        }
        ?>
        <div class="elementor-post__thumbnail" style="padding-bottom: 0"><?php //echo $thumbnail_html; ?></div>
        <?php
    }

    protected function render_title() {
        if ( ! $this->get_instance_value( 'show_title' ) ) {
            return;
        }

        $optional_attributes_html = $this->get_optional_link_attributes_html();
        $tag = $this->get_instance_value( 'title_tag' );
        ?>
        <div class="title" <?php echo $optional_attributes_html; ?>>
            <div>
                <<?php echo $tag; ?> class="wr-resume-title"><?php the_title(); ?><<?php echo $tag; ?>/>
            </div>
        </div>
        <?php
    }

    protected function render_excerpt() {
        add_filter( 'excerpt_more', [ $this, 'filter_excerpt_more' ], 20 );
        add_filter( 'excerpt_length', [ $this, 'filter_excerpt_length' ], 20 );

        if ( ! $this->get_instance_value( 'show_excerpt' ) ) {
            return;
        }

        add_filter( 'excerpt_more', [ $this, 'filter_excerpt_more' ], 20 );
        add_filter( 'excerpt_length', [ $this, 'filter_excerpt_length' ], 20 );

        ?>
        <figcaption class="elementor-post__excerpt">
            <?php the_excerpt(); ?>
        </figcaption>
        <?php

        remove_filter( 'excerpt_length', [ $this, 'filter_excerpt_length' ], 20 );
        remove_filter( 'excerpt_more', [ $this, 'filter_excerpt_more' ], 20 );
    }

    protected function render_post() {
        $this->render_post_header();
        $this->render_thumbnail();
        $this->render_title();
        $this->render_excerpt();
        $this->render_post_footer();
    }
}
