<?php
namespace RubikElementorWidgets\Modules\Posts\Skins;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;
use ElementorPro\Modules\Posts\Skins\Skin_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Skin_Wr_Team extends Skin_Base {

    protected function _register_controls_actions() {
        parent::_register_controls_actions();
    }

    public function get_id() {
        return 'wr_team';
    }

    public function get_title() {
        return __( 'باکس اعضای تیم', 'elementor-pro' );
    }

    public function start_controls_tab( $id, $args ) {
        $args['condition']['_skin'] = $this->get_id();
        $this->parent->start_controls_tab( $this->get_control_id( $id ), $args );
    }

    public function end_controls_tab() {
        $this->parent->end_controls_tab();
    }

    public function start_controls_tabs( $id ) {
        $args['condition']['_skin'] = $this->get_id();
        $this->parent->start_controls_tabs( $this->get_control_id( $id ) );
    }

    public function end_controls_tabs() {
        $this->parent->end_controls_tabs();
    }

    public function register_controls( Widget_Base $widget ) {
        $this->parent = $widget;

        $this->register_columns_controls();
        $this->register_post_count_control();
        $this->register_title_controls();
        $this->register_excerpt_controls();
        $this->register_link_controls();
    }

    public function register_design_controls() {
        $this->register_design_layout_controls();
    }

    protected function register_excerpt_controls() {
        $this->add_control(
            'show_excerpt',
            [
                'label' => __( 'Excerpt', 'elementor-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'elementor-pro' ),
                'label_off' => __( 'Hide', 'elementor-pro' ),
                'default' => 'yes',
            ]
        );
    }

    protected function register_link_controls() {
        $this->add_control(
            'open_new_tab',
            [
                'label' => esc_html__( 'Open in new window', 'elementor-pro' ),
                'type' => Controls_Manager::HIDDEN,
                'label_on' => esc_html__( 'Yes', 'elementor-pro' ),
                'label_off' => esc_html__( 'No', 'elementor-pro' ),
                'default' => 'no',
                'render_type' => 'none',
            ]
        );
    }

    /**
     * Style Tab
     */
    protected function register_design_layout_controls() {
        $this->start_controls_section(
            'section_design_layout',
            [
                'label' => __( 'Layout', 'elementor-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'column_gap',
            [
                'label' => __( 'Columns Gap', 'elementor-pro' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 30,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-posts-container' => 'grid-column-gap: {{SIZE}}{{UNIT}}',
                    '.elementor-msie {{WRAPPER}} .elementor-post' => 'padding-right: calc( {{SIZE}}{{UNIT}}/2 ); padding-left: calc( {{SIZE}}{{UNIT}}/2 );',
                    '.elementor-msie {{WRAPPER}} .elementor-posts-container' => 'margin-left: calc( -{{SIZE}}{{UNIT}}/2 ); margin-right: calc( -{{SIZE}}{{UNIT}}/2 );',
                ],
            ]
        );

        $this->add_control(
            'row_gap',
            [
                'label' => __( 'Rows Gap', 'elementor-pro' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 35,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'frontend_available' => true,
                'selectors' => [
                    '{{WRAPPER}} .elementor-posts-container' => 'grid-row-gap: {{SIZE}}{{UNIT}}',
                    '.elementor-msie {{WRAPPER}} .elementor-post' => 'padding-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render_post_header() {
        $optional_attributes_html = $this->get_optional_link_attributes_html();
        ?>
        <article <?php post_class( [ 'wr-team' ] ); ?>>
        <?php
    }

    protected function render_post_footer() {
        ?>
        </article>
        <?php
    }

    protected function render_thumbnail() {
        if ( 'none' === $this->get_instance_value( 'thumbnail' ) ) {
            return;
        }

        $settings = $this->parent->get_settings();
        $setting_key = $this->get_control_id( 'thumbnail_size' );
        $settings[ $setting_key ] = [
            'id' => get_post_thumbnail_id(),
        ];
        $thumbnail_html = Group_Control_Image_Size::get_attachment_image_html( $settings, $setting_key );

        if ( empty( $thumbnail_html ) ) {
            return;
        }
        ?>
        <div class="image"><?php echo $thumbnail_html; ?>
            <p>
                <?php
                add_filter( 'excerpt_more', [ $this, 'filter_excerpt_more' ], 20 );
                add_filter( 'excerpt_length', [ $this, 'filter_excerpt_length' ], 20 );

                if ( ! $this->get_instance_value( 'show_excerpt' ) ) {
                    return;
                }

                add_filter( 'excerpt_more', [ $this, 'filter_excerpt_more' ], 20 );
                add_filter( 'excerpt_length', [ $this, 'filter_excerpt_length' ], 20 );
                ?>
                <?php the_excerpt(); ?>
                <?php

                remove_filter( 'excerpt_length', [ $this, 'filter_excerpt_length' ], 20 );
                remove_filter( 'excerpt_more', [ $this, 'filter_excerpt_more' ], 20 );
                ?>
            </p>
        </div>
        <?php
    }

    protected function render_title() {
        if ( ! $this->get_instance_value( 'show_title' ) ) {
            return;
        }

        $optional_attributes_html = $this->get_optional_link_attributes_html();
        $tag = $this->get_instance_value( 'title_tag' );
        ?>
        <figcaption <?php echo $optional_attributes_html; ?>>
            <<?php echo $tag; ?> class="wr-team-title"><?php the_title(); ?></<?php echo $tag; ?>>
            <span class="wr-team-position"><?php echo get_post_meta(get_the_ID(), 'wr_team_position', true) ?></span>
            <div class="icons">
                <?php if(get_post_meta(get_the_ID(), 'wr_team_instagram', true)){ ?>
                    <a href="<?php echo str_replace('http://', '', get_post_meta(get_the_ID(), 'wr_team_instagram', true)) ?>" target="_blank"><i class="fab fa-instagram"></i></a>
                <?php } ?>
                <?php if(get_post_meta(get_the_ID(), 'wr_team_linkedin', true)){ ?>
                    <a href="<?php echo str_replace('http://', '', get_post_meta(get_the_ID(), 'wr_team_linkedin', true)) ?>" target="_blank"><i class="fab fa-linkedin-in"></i></a>
                <?php } ?>
                <?php if(get_post_meta(get_the_ID(), 'wr_team_twitter', true)){ ?>
                    <a href="<?php echo str_replace('http://', '', get_post_meta(get_the_ID(), 'wr_team_twitter', true)) ?>" target="_blank"><i class="fab fa-twitter"></i></a>
                <?php } ?>
                <?php if(get_post_meta(get_the_ID(), 'wr_team_facebook', true)){ ?>
                    <a href="<?php echo str_replace('http://', '', get_post_meta(get_the_ID(), 'wr_team_facebook', true)) ?>" target="_blank"><i class="fab fa-facebook-f" style="font-size: 22px"></i></a>
                <?php } ?>
                <?php if(get_post_meta(get_the_ID(), 'wr_team_telegram', true)){ ?>
                    <a href="<?php echo str_replace('http://', '', get_post_meta(get_the_ID(), 'wr_team_telegram', true)) ?>" target="_blank"><i class="fab fa-telegram"></i></a>
                <?php } ?>
            </div>
        </figcaption>
        <?php
    }

    protected function render_post() {
        $this->render_post_header();
        $this->render_thumbnail();
        $this->render_title();
        $this->render_post_footer();
    }
}
