<?php
/**
 * Webrubik Karane admin functions.
 *
 * @package WebrubikKarane
 */

/**
 * Show in WP Dashboard notice about the plugin is not activated.
 *
 * @return void
 */
function webrubik_karane_fail_load_admin_notice() {
	// Leave to Elementor Pro to manage this.
	if ( function_exists( 'elementor_pro_load_plugin' ) ) {
		return;
	}

	$screen = get_current_screen();
	if ( isset( $screen->parent_file ) && 'plugins.php' === $screen->parent_file && 'update' === $screen->id ) {
		return;
	}

	if ( 'true' === get_user_meta( get_current_user_id(), '_webrubik_karane_install_notice', true ) ) {
		return;
	}

	$plugin = 'elementor/elementor.php';

	$installed_plugins = get_plugins();

	$is_elementor_installed = isset( $installed_plugins[ $plugin ] );

	if ( $is_elementor_installed ) {
		if ( ! current_user_can( 'activate_plugins' ) ) {
			return;
		}

		$message = __( 'Hello theme is a lightweight starter theme designed to work perfectly with Elementor Page Builder plugin.', 'webrubik-karane' );

		$button_text = __( 'Activate Elementor', 'webrubik-karane' );
		$button_link = wp_nonce_url( 'plugins.php?action=activate&amp;plugin=' . $plugin . '&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_' . $plugin );
	} else {
		if ( ! current_user_can( 'install_plugins' ) ) {
			return;
		}

		$message = __( 'Hello theme is a lightweight starter theme. We recommend you use it together with Elementor Page Builder plugin, they work perfectly together!', 'webrubik-karane' );

		$button_text = __( 'Install Elementor', 'webrubik-karane' );
		$button_link = wp_nonce_url( self_admin_url( 'update.php?action=install-plugin&plugin=elementor' ), 'install-plugin_elementor' );
	}

	?>
	<style>
		.notice.webrubik-karane-notice {
			border-left-color: #9b0a46 !important;
			padding: 20px;
		}
		.rtl .notice.webrubik-karane-notice {
			border-right-color: #9b0a46 !important;
		}
		.notice.webrubik-karane-notice .webrubik-karane-notice-inner {
			display: table;
			width: 100%;
		}
		.notice.webrubik-karane-notice .webrubik-karane-notice-inner .webrubik-karane-notice-icon,
		.notice.webrubik-karane-notice .webrubik-karane-notice-inner .webrubik-karane-notice-content,
		.notice.webrubik-karane-notice .webrubik-karane-notice-inner .webrubik-karane-install-now {
			display: table-cell;
			vertical-align: middle;
		}
		.notice.webrubik-karane-notice .webrubik-karane-notice-icon {
			color: #9b0a46;
			font-size: 50px;
			width: 50px;
		}
		.notice.webrubik-karane-notice .webrubik-karane-notice-content {
			padding: 0 20px;
		}
		.notice.webrubik-karane-notice p {
			padding: 0;
			margin: 0;
		}
		.notice.webrubik-karane-notice h3 {
			margin: 0 0 5px;
		}
		.notice.webrubik-karane-notice .webrubik-karane-install-now {
			text-align: center;
		}
		.notice.webrubik-karane-notice .webrubik-karane-install-now .webrubik-karane-install-button {
			padding: 5px 30px;
			height: auto;
			line-height: 20px;
			text-transform: capitalize;
		}
		.notice.webrubik-karane-notice .webrubik-karane-install-now .webrubik-karane-install-button i {
			padding-right: 5px;
		}
		.rtl .notice.webrubik-karane-notice .webrubik-karane-install-now .webrubik-karane-install-button i {
			padding-right: 0;
			padding-left: 5px;
		}
		.notice.webrubik-karane-notice .webrubik-karane-install-now .webrubik-karane-install-button:active {
			transform: translateY(1px);
		}
		@media (max-width: 767px) {
			.notice.webrubik-karane-notice {
				padding: 10px;
			}
			.notice.webrubik-karane-notice .webrubik-karane-notice-inner {
				display: block;
			}
			.notice.webrubik-karane-notice .webrubik-karane-notice-inner .webrubik-karane-notice-content {
				display: block;
				padding: 0;
			}
			.notice.webrubik-karane-notice .webrubik-karane-notice-inner .webrubik-karane-notice-icon,
			.notice.webrubik-karane-notice .webrubik-karane-notice-inner .webrubik-karane-install-now {
				display: none;
			}
		}
	</style>
	<script>jQuery( function( $ ) {
			$( 'div.notice.webrubik-karane-install-elementor' ).on( 'click', 'button.notice-dismiss', function( event ) {
				event.preventDefault();

				$.post( ajaxurl, {
					action: 'webrubik_karane_set_admin_notice_viewed'
				} );
			} );
		} );</script>
	<div class="notice updated is-dismissible webrubik-karane-notice webrubik-karane-install-elementor">
		<div class="webrubik-karane-notice-inner">
			<div class="webrubik-karane-notice-icon">
				<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/elementor-logo.png' ); ?>" alt="Elementor Logo" />
			</div>

			<div class="webrubik-karane-notice-content">
				<h3><?php esc_html_e( 'Thanks for installing Hello Theme!', 'webrubik-karane' ); ?></h3>
				<p>
					<p><?php echo esc_html( $message ); ?></p>
					<a href="https://go.elementor.com/hello-theme-learn/" target="_blank"><?php esc_html_e( 'Learn more about Elementor', 'webrubik-karane' ); ?></a>
				</p>
			</div>

			<div class="webrubik-karane-install-now">
				<a class="button button-primary webrubik-karane-install-button" href="<?php echo esc_attr( $button_link ); ?>"><i class="dashicons dashicons-download"></i><?php echo esc_html( $button_text ); ?></a>
			</div>
		</div>
	</div>
	<?php
}

/**
 * Set Admin Notice Viewed.
 *
 * @return void
 */
function ajax_webrubik_karane_set_admin_notice_viewed() {
	update_user_meta( get_current_user_id(), '_webrubik_karane_install_notice', 'true' );
	die;
}

add_action( 'wp_ajax_webrubik_karane_set_admin_notice_viewed', 'ajax_webrubik_karane_set_admin_notice_viewed' );

if ( ! did_action( 'elementor/loaded' ) ) {
	add_action( 'admin_notices', 'webrubik_karane_fail_load_admin_notice' );
}
