<?php
function wr_create_resume_taxonomy() {
    // create a new taxonomy
    register_taxonomy(
        'resume-category',
        'resume',
        array(
            'label' => __( 'Categories' ),
            'rewrite' => array( 'slug' => 'resume-category' ),
            'exclude_from_search' => true,
            'has_archive'         => true,
            'hierarchical'        => true,
        )
    );
}
add_action( 'init', 'wr_create_resume_taxonomy' );

/**
 * Resume Post Type
 */
function wr_custom_post_resume() {
    $labels = array(
        'name'               => _x( 'نمونه کارها', 'post type general name' ),
        'singular_name'      => _x( 'نمونه کار', 'post type singular name' ),
        'add_new'            => _x( 'نمونه کار جدید', 'book' ),
        'add_new_item'       => __( 'افزودن نمونه کار' ),
        'edit_item'          => __( 'ویرایش نمونه کار' ),
        'new_item'           => __( 'نمونه کار جدید' ),
        'all_items'          => __( 'همه نمونه کارها' ),
        'view_item'          => __( 'مشاهده نمونه کار' ),
        'search_items'       => __( 'جستجوی نمونه کار' ),
        'not_found'          => __( 'هیچ نمونه کاری یافت نشد!' ),
        'not_found_in_trash' => __( 'هیچ نمونه کاری در زباله دان یافت نشد!' ),
        'menu_name'          => 'نمونه کارها'
    );
    $args = array(
        'labels'        => $labels,
        'description'   => 'نمونه کارهای خود را به نمایش بگذارید.',
        'public'        => true,
        'menu_position' => 5,
        'supports'      => array( 'title', 'editor', 'excerpt', 'thumbnail' ),
        'show_in_rest'  => true,
        'has_archive'   => true,
        'taxonomies'    => array( 'resume-category' ),
    );
    register_post_type( 'resume', $args );
}
add_action( 'init', 'wr_custom_post_resume' );

/**
 * Service Post Type
 */
function wr_custom_post_service() {
    $labels = array(
        'name'               => _x( 'خدمات', 'post type general name' ),
        'singular_name'      => _x( 'خدمات', 'post type singular name' ),
        'add_new'            => _x( 'خدمات جدید', 'book' ),
        'add_new_item'       => __( 'افزودن خدمات' ),
        'edit_item'          => __( 'ویرایش خدمات' ),
        'new_item'           => __( 'خدمات جدید' ),
        'all_items'          => __( 'همه خدمات' ),
        'view_item'          => __( 'مشاهده خدمات' ),
        'search_items'       => __( 'جستجوی خدمات' ),
        'not_found'          => __( 'هیچ خدماتی یافت نشد!' ),
        'not_found_in_trash' => __( 'هیچ خدماتی در زباله دان یافت نشد!' ),
        'menu_name'          => 'خدمات'
    );
    $args = array(
        'labels'        => $labels,
        'description'   => 'خدمات خود را به نمایش بگذارید.',
        'public'        => true,
        'menu_position' => 6,
        'supports'      => array( 'title', 'editor', 'excerpt', 'thumbnail', 'comments' ),
        'show_in_rest' => true,
        'hierarchical'  => true
    );
    register_post_type( 'service', $args );
}
add_action( 'init', 'wr_custom_post_service' );

/**
 * Team Post Type
 */
function wr_custom_post_team() {
    $labels = array(
        'name'               => _x( 'اعضای تیم', 'post type general name' ),
        'singular_name'      => _x( 'عضو تیم', 'post type singular name' ),
        'add_new'            => _x( 'عضو جدید', 'book' ),
        'add_new_item'       => __( 'افزودن اعضای تیم' ),
        'edit_item'          => __( 'ویرایش اعضای تیم' ),
        'new_item'           => __( 'عضو جدید' ),
        'all_items'          => __( 'همه اعضای تیم' ),
        'view_item'          => __( 'مشاهده عضو' ),
        'search_items'       => __( 'جستجوی اعضای تیم' ),
        'not_found'          => __( 'هیچ عضوی یافت نشد!' ),
        'not_found_in_trash' => __( 'هیچ عضوی در زباله دان یافت نشد!' ),
        'menu_name'          => 'اعضای تیم'
    );
    $args = array(
        'labels'        => $labels,
        'description'   => 'اعضای تیم خود را به نمایش بگذارید.',
        'public'        => true,
        'menu_position' => 7,
        'supports'      => array( 'title', 'excerpt', 'thumbnail' ),
        'show_in_rest' => true,
        'hierarchical'  => true
    );
    register_post_type( 'team', $args );
}
add_action( 'init', 'wr_custom_post_team' );